/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszsenchantments.Registries;
import com.mlib.EquipmentSlots;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfigurable;
import com.mlib.contexts.OnEnchantmentAvailabilityCheck;
import com.mlib.contexts.OnPreDamaged;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.ModConfigs;
import com.mlib.enchantments.CustomEnchantment;
import com.mlib.entities.EntityHelper;
import com.mlib.math.Range;
import com.mlib.modhelper.AutoInstance;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.DamageEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;

public class MisanthropyEnchantment
extends CustomEnchantment {
    public MisanthropyEnchantment() {
        this.rarity(Enchantment.Rarity.UNCOMMON).category(Registries.MELEE_MINECRAFT).slots(EquipmentSlots.MAINHAND).maxLevel(5).minLevelCost(level -> level * 8 - 3).maxLevelCost(level -> level * 8 + 17);
    }

    public boolean m_5975_(Enchantment enchantment) {
        return !(enchantment instanceof DamageEnchantment) && super.m_5975_(enchantment);
    }

    @AutoInstance
    public static class Handler {
        final DoubleConfig damageBonus = new DoubleConfig(2.5, new Range((Number)1.0, (Number)10.0));
        final Supplier<MisanthropyEnchantment> enchantment = Registries.MISANTHROPY;

        public Handler() {
            ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.ENCHANTMENT).name("Misanthropy").comment("Increases the damage against villagers, pillagers, witches and other players.");
            OnEnchantmentAvailabilityCheck.listen((Consumer)OnEnchantmentAvailabilityCheck.ENABLE).addCondition(OnEnchantmentAvailabilityCheck.is(this.enchantment)).addCondition(OnEnchantmentAvailabilityCheck.excludable()).insertTo(group);
            OnPreDamaged.listen(this::increaseDamage).addCondition(Condition.isServer()).addCondition(Condition.hasEnchantment(this.enchantment, data -> data.attacker)).addCondition(Condition.predicate(data -> EntityHelper.isHuman((Entity)data.target))).addConfig((IConfigurable)this.damageBonus.name("damage_bonus").comment("Extra damage dealt to humans per enchantment level.")).insertTo(group);
        }

        private void increaseDamage(OnPreDamaged.Data data) {
            data.extraDamage += (float)this.enchantment.get().getEnchantmentLevel(data.attacker) * this.damageBonus.asFloat();
            data.spawnMagicParticles = true;
        }
    }
}

